#include <algorithm>
#include <cmath>
#include <iostream>
#include <vector>
using namespace std;

typedef long long ll;
typedef long double lf;

lf dist(ll a, ll b, ll c, ll d) {
  return sqrt((a - c) * (a - c) + (b - d) * (b - d));
}

int main() {
  int n;
  cin >> n;
  vector<pair<lf, int>> events;
  for (int i = 0; i < n; ++i) {
    long long a, b, c, d;
    cin >> a >> b >> c >> d;
    // A je (a, b), B je (c, d), C je ishodiste
    lf AB = dist(a, b, c, d);
    lf AC = dist(a, b, 0, 0);
    lf BC = dist(c, d, 0, 0);
    lf pov = abs(a * d - c * b) / 2.0;
    lf visina = 2 * pov / AB;
    lf lijevo = sqrt(AC * AC - visina * visina);
    lf desno = sqrt(BC * BC - visina * visina);
    lf L = 0;
    if (lijevo >= AB || desno >= AB) {
      L = min(AC, BC);
    } else {
      L = visina;
    }
    lf R = max(AC, BC);
    events.push_back({L, -1});
    events.push_back({R, 1});
  }
  sort(events.begin(), events.end());

  int tmp = 0;
  int ans = 0;
  for (auto ev : events) {
    tmp -= ev.second;
    ans = max(ans, tmp);
  }
  cout << ans << endl;
  return 0;
}
